﻿var distributionStatus = {
    context: $(".v-distributionStatus"),
    datatable: null,
    initialize: function () {
        var distributionId = $(".distributionId").val();

        this.datatable = $(".h-distribution-respondents-table", distributionStatus.context).a4datatable({            
            ajaxAction: a4.getSurveyAction("GetDistributionRespondents", "Distribute"),
            ajaxParams: { "distributionId": distributionId },
            style: "compact",
            displayColumnSelector: false,
            displaySearchBox: canReadPII,
            columns: [
                { "Name": "RespondentId", "Title": resources.Id, "Data": "RespondentId", "Width": "70px" },
                { "Name": "RespondentEmail", "Title": resources.Email, "Data": "RespondentEmail", "Visible": canReadPII, "HideInSelector": !canReadPII },
                { "Name": "RespondentPhone", "Title": resources.Phone, "Data": "RespondentPhone", "Visible": canReadPII, "HideInSelector": !canReadPII },
                { "Name": "DispositionCode", "Title": resources.Status, "Data": "DispositionCode", "Width": "100px" },
                { "Name": "AccessDate", "Title": resources.AccessDate, "Data": "AccessDate", "Width": "130px" }
            ],
            quickFilter: {
                "DisplayAsButtons": true,
                "Items": [
                    { "Label": resources.Started, "AjaxParams": { "status": 0 } },
                    { "Label": resources.Completed, "AjaxParams": { "status": 1 } },
                    { "Label": resources.Dropped, "AjaxParams": { "status": 2 } },
                    { "Label": resources.ScreenedOut, "AjaxParams": { "status": 3 } }
                ]
            }
        });

        a4.callServerMethod(a4.getSurveyAction("DistributionStatusChart", "Distribute"), { id: distributionId }, function (result) {
            a4.initChart($(".chart"), result);
        });
    },
    bindEvents: function () {
        a4.showBusyBox();

        distributionStatus.context.on("click", ".h-exportRespondents", function () {
            var tableParams = distributionStatus.datatable.a4datatable("getTableParams");
            var distributionId = $(".distributionId").val();

            a4.callServerMethod(a4.getSurveyAction("ExportDistributionRespondents", "Distribute"), { tableParams: JSON.stringify(tableParams), distributionId: distributionId },
            function (result) {
                a4.hideBusyBox();
                window.location = a4.getSurveyAction("GetDistributionRespondentsFile", "Distribute", { fileName: result });
            },
            function (error) {
                a4.onAjaxPageMethodError(error);
            });

        });
    }
}

$(document).ready(function () {
    if (distributionStatus.context.length > 0) {
        distributionStatus.initialize();
    }
});